import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class GUI extends JFrame {
	
	private class ZaDugmice implements ActionListener{
		private int i, upisi;
		public void actionPerformed(ActionEvent e){
			MyButton b = (MyButton) e.getSource();
			if (!b.zakljucano()){
				b.otvori();
				for (i=0; i<dugmici.length; i++)
					if (b.equals(dugmici[i])) break;
				if (eng.cuvaj(i)){
					prvi=eng.getPrvi();
					drugi=eng.getDrugi();
					eng.setPokusaji();
					pokusaji.setText("Broj pokusaja: "+eng.getPokusaji());
					if (eng.poredi()){
						b.zakljucaj();
						pogodak=true;
						try{
							eng.setPogoci();
						}
						catch(Zavrseno exc){
							String poruka="Pogodili ste iz "+eng.getPokusaji()+". pokusaja.\nNova igra?";
							int op=JOptionPane.showConfirmDialog(null, poruka, "Disney MEMO", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);
							if (op==JOptionPane.NO_OPTION) System.exit(0);
							else nova();
						}
						pogoci.setText("Broj pogodaka: "+(eng.getPogoci()));
					}
					else{
						dugmici[prvi].otkljucaj();
						pogodak=false;
					}
				}
				else {
					b.zakljucaj();
					if (!pogodak){
						if (b!=dugmici[prvi]) dugmici[prvi].zatvori();
						if (b!=dugmici[drugi]) dugmici[drugi].zatvori();
					}
				}
			}
		}
	}
	
	private Engine eng = new Engine();
	private JPanel cp, centar;
	private MyButton[] dugmici = new MyButton[30];
	private JLabel pokusaji, pogoci;
	private boolean pogodak=true;
	private int prvi, drugi;
	
	public GUI(){
		setBounds(550,200,500,500);
		setTitle("Disney MEMO");
		cp=(JPanel)getContentPane();
		namestiKomponente();
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setVisible(true);
	}
	
	private void namestiKomponente(){
		namestiSever();
		namestiJug();
		namestiCentar();
	}
	
	private void namestiSever(){
		pokusaji = new JLabel("Broj pokusaja: 0");
		pokusaji.setForeground(Color.white);
		pogoci = new JLabel("Broj pogodaka: 0");
		pogoci.setForeground(Color.white);
		JPanel sever = new JPanel(new FlowLayout(FlowLayout.LEFT));
		sever.add(pokusaji);
		sever.add(pogoci);
		cp.add(sever, BorderLayout.NORTH);
		sever.setBackground(Color.gray);
	}
	
	private void namestiJug(){
		JButton nova = new JButton("Nova");
		JPanel jug = new JPanel(new FlowLayout());
		jug.add(nova);
		cp.add(jug,BorderLayout.SOUTH);
		jug.setBackground(Color.gray);
		nova.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				nova();
			}
		});
	}
	
	private void namestiCentar(){
		centar = new JPanel(new GridLayout(5,6,5,5));
		centar.setBorder(BorderFactory.createLineBorder(Color.white, 5));
		popuniDugmice();
		cp.add(centar, BorderLayout.CENTER);
	}
	
	private void nova(){
		centar.removeAll();
		eng.reset();
		popuniDugmice();
		centar.updateUI();
		pokusaji.setText("Broj pokusaja: 0");
		pogoci.setText("Broj pogodaka: 0");
	}
	
	private void popuniDugmice(){
		for (int i=0; i<30; i++){
			dugmici[i]=new MyButton(eng.uzmiSliku(i));
			dugmici[i].addActionListener(new ZaDugmice());
			centar.add(dugmici[i]);
		}
	}

}
